clear all; close all; clc;

Data=xlsread('Data.xlsx','Monthly','b2:u685');         % MKT variance

Rcrsp=Data(:,1)/100;         % Fama-French CRSP VW MKT excess return
Rm=Rcrsp;
Rm_out=Rcrsp(2:end);%% one-month ahead Rm: Rm_{t+1}
   
sigRm=Data(:,2);            % Market variance
skRm_std=Data(:,3);       % Market skewness
VWVol=Data(:,4);            % Value-weighted variance
EWVol=Data(:,5);            % Equal-weighted variance
VWSkew=Data(:,6);         % Value-weighted skewness
EWSkew=Data(:,7);         % Equal-weighted skewness
DP=Data(:,8);                 % Dividend-price ratio
DEF=Data(:,9);               % Default 
Term=Data(:,10);           % Term Premium
RREL=Data(:,11);            % Relative 3-month Treasury-bill rate
ILLIQ_ze=Data(:,12);      % Expected Iliquidity
PC_GW=Data(:,13);         % 1st PC of 14 Econ Variables
AVG_GW=Data(:,14);      % Average of 14 Econ Variables
corrRiRjw=Data(:,15);     % Average Correlation
SII_long=Data(:,16);       % SII
VIX=Data(:,17);               % Square Root of VIX
TailRisk=Data(:,18);        % Tail Risk
VRP=Data(:,19);              % Variance Risk Premium
TailRiskPrem=Data(:,20); %Tail Risk Premim 

allv1=[Rm   sigRm*100   skRm_std   VWVol   EWVol   VWSkew   EWSkew     ];
allv=[Rm_out  allv1(1:end-1,:)];

beg=(63-60)*12+7 ;%% summary stat sample: August 1963 to December 2016
 

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % This part of the code constructs Summary Statistics (Table 1)
% % Sample: August 1963 to December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% whole sample statistics
[meana,mediana,mina,maxa,stda, ARa]=Sample_statistics(allv1(1+beg:end,:)); 
stata=[meana mina mediana maxa stda ARa];

disp('Table 1: Summary Statistics and Correlation Matrix')
disp('Panel A: Summary statistics')
disp('    Mean      Min       Med       Max       Std       AR1')
disp(stata)
disp(' ')
disp('Panel B: Correlation matrix')
X=corrcoef(allv(1+beg:end,:) );
CorrMatrix = tril(X);
disp('   R_{m,t+1} R_{m,t}   V_{m,t}   Sk_{m,t}  V_{vw,t}  V_{ew,t}  Sk_{vw,t}  Sk_{ew,t}');
disp(CorrMatrix)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % This part of the code constructs Preliminary Regressions (Table 2)
% % Sample: August 1963 to December 2016/ January 1990 to December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

beg=(63-60)*12+8 ;%% regression sample: August 1963 to December 2016
% beg=(90-60)*12+1 ;%% regression sample: January 1990 to December 2016

y=Rm_out; 
X=sigRm;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names1= {'aConstant';'b$V_{m,t}$'};
results.results1=coeft(:,1:2)  ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;

X=skRm_std;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names2= {'aConstant';'c$Sk_{m,t}$'};
results.results2=coeft(:,1:2)  ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;

X=VWVol ;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names3= {'aConstant';'d$V_{vw,t}$'};
results.results3=coeft(:,1:2)  ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=VWSkew ;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names4= {'aConstant';'e$Sk_{vw,t}$'};
results.results4=coeft(:,1:2)  ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;

X=EWVol;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names5= {'aConstant';'f$V_{ew,t}$'};
results.results5=coeft(:,1:2)  ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;

X=EWSkew ;  
[coeft,R2]=Reg_NeweyWest(y,X,beg); 
names.names6= {'aConstant';'g$Sk_{ew,t}$'};
results.results6=coeft(:,1:2)  ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' } ;

model_names= {'I'; 'II';'III'; 'IV'; 'V'; 'VI'}   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table2=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table2
clear results names more_results more_results_names model_names table_opts start stop round_digits 
 
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % This part of the code constructs Regressions with combination of variables (Table 3)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

y=Rm_out;
X=[sigRm skRm_std];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant';'c$V_{m,t}$';'d$Sk_{m,t}$' };
results.results1=coeft(:,1:2)  ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;
 
X=[VWVol VWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant';'e$V_{vw,t}$';'f$Sk_{vw,t}$' };
results.results2=coeft(:,1:2)  ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;

X=[EWVol EWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';'g$V_{ew,t}$';'h$Sk_{ew,t}$' };
results.results3=coeft(:,1:2)  ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=[sigRm skRm_std  VWVol VWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant';'c$V_{m,t}$';'d$Sk_{m,t}$';'e$V_{vw,t}$';'f$Sk_{vw,t}$' };
results.results4=coeft(:,1:2)  ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;

X=[ sigRm skRm_std  EWVol EWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names5= {'aConstant';'c$V_{m,t}$';'d$Sk_{m,t}$';'g$V_{ew,t}$';'h$Sk_{ew,t}$' };
results.results5=coeft(:,1:2)  ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;

X=[Rm sigRm skRm_std  VWVol VWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names6= {'aConstant';'b$R_{m,t}$';'c$V_{m,t}$';'d$Sk_{m,t}$';'e$V_{vw,t}$';'f$Sk_{vw,t}$' };
results.results6=coeft(:,1:2)  ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' } ;
 
X=[Rm sigRm skRm_std  EWVol EWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names7= {'aConstant';'b$R_{m,t}$';'c$V_{m,t}$';'d$Sk_{m,t}$';'g$V_{ew,t}$';'h$Sk_{ew,t}$' };
results.results7=coeft(:,1:2)  ;
more_results.more_results7=R2 ;
more_results_names.more_results_names7= { 'Adjusted $R^2$' } ;

X=[Rm  VWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names8= {'aConstant';'b$R_{m,t}$';'f$Sk_{vw,t}$' };
results.results8=coeft(:,1:2)  ;
more_results.more_results8=R2 ;
more_results_names.more_results_names8= { 'Adjusted $R^2$' } ;
 
X=[Rm  EWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names9= {'aConstant';'b$R_{m,t}$';'h$Sk_{ew,t}$' };
results.results9=coeft(:,1:2)  ;
more_results.more_results9=R2 ;
more_results_names.more_results_names9= { 'Adjusted $R^2$' } ;
 
model_names= {'I'; 'II';'III'; 'IV'; 'V'; 'VI'; 'VII'; 'VIII'; 'IX'}   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table3=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table3
clear results names more_results more_results_names model_names table_opts start stop round_digits 
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Macro Variables and Illiquidity Measures (Table 4)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

y=Rm_out;
X=[  VWSkew DP DEF Term RREL   ];   
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant'; 'c$Sk_{vw,t}$';'d$DP_{t}$'; 'e$DEF_{t}$'; 'f$TERM_{t}$';'g$RREL_{t}$'};
results.results1=coeft ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;

X=[  Rm VWSkew DP DEF Term RREL   ];   
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant'; 'b$R_{m,t}$'; 'c$Sk_{vw,t}$';'d$DP_{t}$'; 'e$DEF_{t}$'; 'f$TERM_{t}$';'g$RREL_{t}$'};
results.results2=coeft ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;

X=[   VWSkew    DP DEF Term RREL    ILLIQ_ze  ];   
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';;'c$Sk_{vw,t}$';'d$DP_{t}$'; 'e$DEF_{t}$'; 'f$TERM_{t}$';'g$RREL_{t}$';'h$ILLIQ^E_{t}$' };
results.results3=coeft ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=[ Rm  VWSkew    DP DEF Term RREL    ILLIQ_ze  ];   
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant'; 'b$R_{m,t}$';'c$Sk_{vw,t}$';'d$DP_{t}$'; 'e$DEF_{t}$'; 'f$TERM_{t}$';'g$RREL_{t}$';'h$ILLIQ^E_{t}$' };
results.results4=coeft ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;

model_names= {'I'; 'II' ;'III'; 'IV'  }   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table4 =outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table4
clear results names more_results more_results_names model_names table_opts start stop round_digits 
   

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Econ PC and Econ AVG (Table 5)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
y=Rm_out; 
X=[VWSkew];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant'; 'c$Sk_{vw,t}$'};
results.results1=coeft(:,1:2)  ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;
 
X=[ PC_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant'; 'd$ECON_{PC,t}$'};
results.results2=coeft(:,1:2);
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;

X=[VWSkew  PC_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';'c$Sk_{vw,t}$'; 'd$ECON_{PC,t}$'};
results.results3=coeft(:,1:2)  ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=[Rm  VWSkew  PC_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant';'b$r_{m,t}$';'c$Sk_{vw,t}$';'d$ECON_{PC,t}$'};
results.results4=coeft(:,1:2)  ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;
 
X=[ AVG_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names5= {'aConstant'; 'e$ECON_{AVG,t}$'};
results.results5=coeft(:,1:2)  ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;

X=[VWSkew  AVG_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names6= {'aConstant';'c$Sk_{vw,t}$'; 'e$ECON_{AVG,t}$'};
results.results6=coeft(:,1:2)  ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' } ;
 
X=[Rm VWSkew  AVG_GW(:,1) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names7= {'aConstant';'b$r_{m,t}$';'c$Sk_{vw,t}$';'e$ECON_{AVG,t}$'};
results.results7=coeft(:,1:2);
more_results.more_results7=R2 ;
more_results_names.more_results_names7= { 'Adjusted $R^2$' } ;

model_names= {'I'; 'II';'III';'IV';'V';'VI'; 'VII'}   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table5=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table5
clear results names more_results more_results_names model_names table_opts start stop round_digits 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Financial Variables (Table 6)
%% Part 1: AC and SII
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

beg=(63-60)*12+8 ;%% regression sample: August 1963 to December 2016

y=Rm_out; 
X=[ VWSkew   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant'; 'c$Sk_{vw,t}$'};
results.results1=coeft(:,1:2)  ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;
 
X=[ corrRiRjw ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant'; 'd$Xt$' };
results.results2=coeft(:,1:2) ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' };    

X=[  VWSkew   corrRiRjw];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';  'c$Sk_{vw,t}$' ; 'd$Xt$'};
results.results3=coeft(:,1:2) ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=[Rm  VWSkew   corrRiRjw];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant';'b$r_{m,t}$'; 'c$Sk_{vw,t}$' ; 'd$Xt$'};
results.results4=coeft(:,1:2) ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;


beg=(73-60)*12+1 ;%% regression sample: January 1963 to December 2016

y=Rm_out; 
X=[ VWSkew   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names5= {'aConstant'; 'c$Sk_{vw,t}$'};
results.results5=coeft(:,1:2)  ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;
 
X=[ SII_long ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names6= {'aConstant'; 'd$Xt$' };
results.results6=coeft(:,1:2) ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' };    

X=[  VWSkew   SII_long];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names7= {'aConstant';  'c$Sk_{vw,t}$' ; 'd$Xt$'};
results.results7=coeft(:,1:2) ;
more_results.more_results7=R2 ;
more_results_names.more_results_names7= { 'Adjusted $R^2$' } ;

X=[Rm  VWSkew   SII_long];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names8= {'aConstant';'b$r_{m,t}$'; 'c$Sk_{vw,t}$' ; 'd$Xt$'};
results.results8=coeft(:,1:2) ;
more_results.more_results8=R2 ;
more_results_names.more_results_names8= { 'Adjusted $R^2$' } ;

model_names= {'I'; 'II';'III';'IV';'V';'VI';'VII';'VIII'}   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table6_ACSII=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table6_ACSII
clear results names more_results more_results_names model_names table_opts start stop round_digits 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Financial Variables (Table 6)
%% Part 2: VIX and TR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

beg=(90-60)*12+1 ;%% regression sample: January 1963 to December 2016

y=Rm_out(1:end-12);
X=[ VWSkew(1:end-12)   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant';  'c$Sk_{vw,t}$'  };
results.results1=coeft(:,1:2) ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;

X=[ VIX(1:end-12)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant';  'd$Xt$'  };
results.results2=coeft(:,1:2) ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;


X=[ VWSkew(1:end-12)  VIX(1:end-12)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';  'c$Sk_{vw,t}$';'d$Xt$'  };
results.results3=coeft(:,1:2) ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

 
X=[Rm(1:end-12)  VWSkew(1:end-12)  VIX(1:end-12)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant';'b$r_{m,t}$';   'c$Sk_{vw,t}$';'d$Xt$'  };
results.results4=coeft(:,1:2) ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;

  
beg=(63-60)*12+8 ;%% regression sample: January 1963 to December 2016

y=Rm_out; 

X=[   VWSkew   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names5= {'aConstant';  'c$Sk_{vw,t}$'  };
results.results5=coeft(:,1:2) ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;

X=[ TailRisk];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names6= {'aConstant';  'd$Xt$'  };
results.results6=coeft(:,1:2) ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' } ;

X=[  VWSkew   TailRisk ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names7= {'aConstant';  'c$Sk_{vw,t}$' ;'d$Xt$' };
results.results7=coeft(:,1:2) ;
more_results.more_results7=R2 ;
more_results_names.more_results_names7= { 'Adjusted $R^2$' } ;

X=[Rm  VWSkew   TailRisk ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names8= {'aConstant';'b$r_{m,t}$';  'c$Sk_{vw,t}$'  ;'d$Xt$' };
results.results8=coeft(:,1:2) ;
more_results.more_results8=R2 ;
more_results_names.more_results_names8= { 'Adjusted $R^2$' } ;
model_names= {'I'; 'II';'III';'IV';'V';'VI';'VII';'VIII'}   ; %
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table6_VIXTR=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table6_VIXTR
clear results names more_results more_results_names model_names table_opts start stop round_digits 
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Financial Variables (Table 6)
%% Part 3: VRP and TRP
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

beg=(96-60)*12+1 ;%% regression sample: January 1963 to December 2016

y=Rm_out(1:end-40);
X=[ VWSkew(1:end-40)   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names1= {'aConstant';  'c$Sk_{vw,t}$'  };
results.results1=coeft(:,1:2) ;
more_results.more_results1=R2 ;
more_results_names.more_results_names1= { 'Adjusted $R^2$' } ;

X=[ VRP(1:end-40)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names2= {'aConstant';  'd$Xt$'  };
results.results2=coeft(:,1:2) ;
more_results.more_results2=R2 ;
more_results_names.more_results_names2= { 'Adjusted $R^2$' } ;

X=[ VWSkew(1:end-40)  VRP(1:end-40)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names3= {'aConstant';  'c$Sk_{vw,t}$';'d$Xt$'  };
results.results3=coeft(:,1:2) ;
more_results.more_results3=R2 ;
more_results_names.more_results_names3= { 'Adjusted $R^2$' } ;

X=[Rm(1:end-40)  VWSkew(1:end-40)  VRP(1:end-40)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names4= {'aConstant';'b$r_{m,t}$';   'c$Sk_{vw,t}$';'d$Xt$'  };
results.results4=coeft(:,1:2) ;
more_results.more_results4=R2 ;
more_results_names.more_results_names4= { 'Adjusted $R^2$' } ;

X=[ VWSkew(1:end-40)   ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names5= {'aConstant';  'c$Sk_{vw,t}$'  };
results.results5=coeft(:,1:2) ;
more_results.more_results5=R2 ;
more_results_names.more_results_names5= { 'Adjusted $R^2$' } ;

X=[ TailRiskPrem(1:end-40)];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names6= {'aConstant';  'd$Xt$'  };
results.results6=coeft(:,1:2) ;
more_results.more_results6=R2 ;
more_results_names.more_results_names6= { 'Adjusted $R^2$' } ;

X=[  VWSkew(1:end-40)   TailRiskPrem(1:end-40) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names7= {'aConstant';  'c$Sk_{vw,t}$' ;'d$Xt$' };
results.results7=coeft(:,1:2) ;
more_results.more_results7=R2 ;
more_results_names.more_results_names7= { 'Adjusted $R^2$' } ;

X=[Rm(1:end-40)  VWSkew(1:end-40)  TailRiskPrem(1:end-40) ];  
[coeft,R2]=Reg_NeweyWestMulti(y,X,beg); 
names.names8= {'aConstant';'b$r_{m,t}$';  'c$Sk_{vw,t}$'  ;'d$Xt$' };
results.results8=coeft(:,1:2) ;
more_results.more_results8=R2 ;
more_results_names.more_results_names8= { 'Adjusted $R^2$' } ;

model_names= {'I'; 'II';'III';'IV';'V';'VI';'VII';'VIII'}   ; 
table_opts='table';
start=[];
stop=[];
round_digits=4;
Table6_VRPTRP=outreg_latexeeNostar(results,names,more_results,more_results_names,model_names,table_opts,start ,stop ,round_digits);
Table6_VRPTRP
clear results names more_results more_results_names model_names table_opts start stop round_digits 
